
<!--sidebar end-->
<!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <section class="panel">
            <header class="panel-heading">
                <?php echo lang('staff'); ?> <?php echo lang('list'); ?>
                <div class="clearfix no-print col-md-8 pull-right">
                <?php echo validation_errors(); ?>
                    <div class="pull-right"></div>
                    <a data-toggle="modal" href="#myModal">
                        <div class="btn-group pull-right">
                            <button id="" class="btn green btn-xs">
                                <i class="fa fa-plus-circle"></i>  <?php echo lang('add_new'); ?> <?php echo lang('staff'); ?> 
                            </button>
                        </div>
                    </a>
                </div>
            </header>
            <div class="panel-body">
                <div class="adv-table editable-table ">

                    <div class="space15"></div>
                    <table class="table table-striped table-hover table-bordered" id="editable-sample">
                        <thead>
                            <tr>
                                <th><?php echo lang('id'); ?></th>
                                <th><?php echo lang('image'); ?></th>
                                <th><?php echo lang('name'); ?></th>
                                <th><?php echo lang('department'); ?></th>
                                <th><?php echo lang('email'); ?></th>
                                <th><?php echo lang('phone'); ?></th>
                                <th><?php echo lang('address'); ?></th>
                                <th><?php echo lang('joining'); ?> <?php echo lang('date'); ?></th>
                                <th><?php echo lang('status'); ?></th>
                                <th><?php echo lang('basic'); ?> <?php echo lang('salary'); ?></th>
                                <th class="no-print"><?php echo lang('options'); ?></th>
                            </tr>
                        </thead>
                        <tbody>

                        <?php foreach ($staffs as $staff) { ?>
                            <tr class="">
                                <td><?php echo $staff->id; ?></td>
                                <td><img  style="width:50px" class="img-rounded" src="<?php if (empty($staff->img_url)) echo "uploads/cardiology-patient-icon-vector-6244713.jpg"; else echo $staff->img_url; ?>"></td>
                                <td><?php echo $staff->name; ?></td>
                                <td><?php echo $this->db->get_where('department', array('id' => $staff->department))->row()->name; ?></td>
                                <td><?php echo $staff->email; ?></td>
                                <td><?php echo $staff->phone; ?></td>
                                <td><?php echo $staff->address; ?></td>
                                <td><?php echo $staff->joining_date; ?></td>
                                <td>
                                <?php if ($staff->status == lang('status_working')) { ?>
                                    <span class="badge bg-primary"><?php echo $staff->status; ?></span>
                                    <?php } else { ?> 
                                    <span class="badge bg-warning"><?php echo $staff->status; ?></span>
                                <?php } ?> 
                                </td>
                                <td><?php echo $settings->currency; ?> <?php echo number_format($staff->basic_salary); ?></td>
                                <td class="no-print">
                                    <?php echo ' <a type="button" class="btn detailsbutton inffo" title="' . lang('info') . '" data-toggle = "modal" data-id="' . $staff->id . '"><i class="fa fa-info"> </i> ' . lang('info') . '</a>'; ?>
                                    <button type="button" class="btn btn-info btn-xs btn_width editbutton" title="<?php echo lang('edit'); ?>" data-toggle="modal" data-id="<?php echo $staff->id; ?>"><i class="fa fa-edit"></i> <?php echo lang('edit'); ?></button>   
                                    <a class="btn btn-info btn-xs btn_width delete_button" title="<?php echo lang('delete'); ?>" href="staff/deleteStaff?id=<?php echo $staff->id; ?>" onclick="return confirm('Are you sure you want to delete this item?');"><i class="fa fa-trash"></i> <?php echo lang('delete'); ?></a>
                                </td>
                            </tr>
                        <?php } ?>

                        </tbody>
                    </table>
                </div>
            </div>
        </section>
        <!-- page end-->
    </section>
</section>
<!--main content end-->
<!--footer start-->


<!-- Add Staff Modal-->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title"><?php echo lang('add_new'); ?> <?php echo lang('staff'); ?></h4>
            </div>
            <div class="modal-body">
                <form role="form" action="staff/addNew" class="clearfix" method="post" enctype="multipart/form-data">
                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('name'); ?>*</label>
                        <input type="text" class="form-control" name="name" required>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('email'); ?></label>
                        <input type="text" class="form-control" name="email">
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('gender'); ?>*</label>
                        <select class="form-control" name="gender" required> 
							<option value="">Select</option>  
                            <option><?php echo lang('male'); ?></option> 
                            <option><?php echo lang('female'); ?></option> 
                            <option><?php echo lang('others'); ?></option> 
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('address'); ?>*</label>
                        <input type="text" class="form-control" name="address" required>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('phone'); ?>*</label>
                        <input type="text" class="form-control" name="phone" required>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('birth'); ?> <?php echo lang('date'); ?></label>
                        <input type="text" class="form-control default-date-picker" name="birth_date" readonly required>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('joining'); ?> <?php echo lang('date'); ?>*</label>
                        <input type="text" class="form-control default-date-picker" name="joining_date" readonly required>
                    </div>

                    <div class="form-group">
                                <label for="exampleInputEmail1"><?php echo lang('department'); ?>*</label>
                                <select class="form-control m-bot15" name="department" required>
                                <option value="">Select..</option>
                                    <?php foreach ($departments as $department) { ?>
                                        <option value="<?php echo $department->id; ?>">
                                         <?php echo $department->name; ?> 
                                        </option>
                                    <?php } ?> 
                                </select>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('basic'); ?> <?php echo lang('salary'); ?>*</label>
                        <input type="number" class="form-control" name="basic_salary" required>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('working'); ?> <?php echo lang('status'); ?>*</label>
                        <select class="form-control" name="status" required>  
                            <option><?php echo lang('status_working'); ?></option> 
                            <option><?php echo lang('status_left'); ?></option> 
                        </select>
                    </div>

                    <div class="form-group">
                        <label class="control-label"><?php echo lang('image'); ?></label>
                        <div class="">
                            <div class="fileupload fileupload-new" data-provides="fileupload">
                                <div class="fileupload-new thumbnail" style="width: 200px; height: 150px;">
                                    <img src="//www.placehold.it/200x150/EFEFEF/AAAAAA&amp;text=no+image" alt="" />
                                </div>
                                <div class="fileupload-preview fileupload-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 20px;"></div>
                                <div>
                                    <span class="btn btn-white btn-file">
                                        <span class="fileupload-new"><i class="fa fa-paper-clip"></i> Select image</span>
                                        <span class="fileupload-exists"><i class="fa fa-undo"></i> Change</span>
                                        <input type="file" class="default" name="img_url"/>
                                    </span>
                                </div>
                            </div>

                        </div>
                    </div>

                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash();?>" />
                    <div class="form-group col-md-12">
                        <button type="submit" name="submit" class="btn btn-info pull-right row"><?php echo lang('submit'); ?></button>
                    </div>

                </form>

            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<!-- Add Staff Modal-->

<!-- Info Staff Modal-->
<div class="modal fade" id="infoModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-lg"> 
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">  <?php echo lang('staff'); ?>  <?php echo lang('info'); ?> (<?php echo lang('id'); ?>: <span class="staffIdClass text-primary"></span>)</h4>
            </div>
            <div class="modal-body row">
                <form role="form" id="infoStaffForm" action="staff/addNew" class="clearfix" method="post" enctype="multipart/form-data">

                    <div class="form-group last col-md-4">
                        <div class="">
                            <div class="fileupload fileupload-new" data-provides="fileupload">
                                <div class="fileupload-new thumbnail" style="width: 150px;">
                                    <img src="//www.placehold.it/200x150/EFEFEF/AAAAAA&amp;text=no+image" id="img1" alt="" />
                                </div>
                                <div class="fileupload-preview fileupload-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 20px;"></div>
                            </div>

                            <div class="col-md-12">
                                <label for="exampleInputEmail1"><?php echo lang('basic'); ?> <?php echo lang('salary'); ?>:</label> <span class="basicSalaryClass"></span>
                            </div>

                            <div class="col-md-12">
                                <label for="exampleInputEmail1"><?php echo lang('updated'); ?>: </label> <span class="updateDateClass"></span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group col-md-4">
                        <label for="exampleInputEmail1"><?php echo lang('name'); ?></label>
                        <div class="nameClass"></div>
                    </div>

                    <div class="form-group col-md-4">
                        <label for="exampleInputEmail1"><?php echo lang('department'); ?></label>
                        <div class="departmentClass"></div>
                    </div>

                    <div class="form-group col-md-4">
                        <label for="exampleInputEmail1"><?php echo lang('email'); ?></label>
                        <div class="emailClass"></div>
                    </div>

                    <div class="form-group col-md-4">
                        <label for="exampleInputEmail1"><?php echo lang('address'); ?></label>
                        <div class="addressClass"></div>
                    </div>

                    <div class="form-group col-md-4">
                        <label for="exampleInputEmail1"><?php echo lang('phone'); ?></label>
                        <div class="phoneClass"></div>
                    </div>

                    <div class="form-group col-md-4">
                        <label for="exampleInputEmail1"><?php echo lang('gender'); ?></label>
                        <div class="genderClass"></div>
                    </div>

                    <div class="form-group col-md-4">
                        <label><?php echo lang('birth_date'); ?></label>
                        <div class="birthdateClass"></div>     
                    </div>

                    <div class="form-group col-md-4">
                        <label><?php echo lang('joining'); ?> <?php echo lang('date'); ?></label>
                        <div class="joiningClass"></div>     
                    </div>

                    <div class="form-group col-md-4">    
                    </div>
                </form>

            </div><!-- /.modal-content -->
        </div><!-- /.modal-dialog -->
    </div>
</div>
<!-- Info Staff Modal-->

<!-- Edit Event Modal-->
<div class="modal fade" id="myModal2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title"><?php echo lang('edit'); ?> <?php echo lang('staff'); ?></h4>
            </div>
            <div class="modal-body">
                <form role="form" id="editStaffForm" class="clearfix" action="staff/addNew" method="post" enctype="multipart/form-data">
                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('staff'); ?> <?php echo lang('id'); ?></label>
                        <input type="text" class="form-control" name="id" value='' placeholder="" readonly>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('name'); ?>*</label>
                        <input type="text" class="form-control" name="name" required>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('email'); ?></label>
                        <input type="text" class="form-control" name="email">
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('gender'); ?>*</label>
                        <select class="form-control" name="gender" required> 
							<option value="">Select</option>  
                            <option><?php echo lang('male'); ?></option> 
                            <option><?php echo lang('female'); ?></option> 
                            <option><?php echo lang('others'); ?></option> 
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('address'); ?>*</label>
                        <input type="text" class="form-control" name="address" required>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('phone'); ?>*</label>
                        <input type="text" class="form-control" name="phone" required>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('birth'); ?> <?php echo lang('date'); ?></label>
                        <input type="text" class="form-control default-date-picker" name="birth_date" readonly required>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('joining'); ?> <?php echo lang('date'); ?>*</label>
                        <input type="text" class="form-control default-date-picker" name="joining_date" readonly required>
                    </div>

                    <div class="form-group">
                                <label for="exampleInputEmail1"><?php echo lang('department'); ?>*</label>
                                <select class="form-control m-bot15" name="department" required>
                                <option value="">Select..</option>
                                    <?php foreach ($departments as $department) { ?>
                                        <option value="<?php echo $department->id; ?>">
                                         <?php echo $department->name; ?> 
                                        </option>
                                    <?php } ?> 
                                </select>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('basic'); ?> <?php echo lang('salary'); ?>*</label>
                        <input type="number" class="form-control" name="basic_salary" required>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('working'); ?> <?php echo lang('status'); ?>*</label>
                        <select class="form-control" name="status" required>  
                            <option><?php echo lang('status_working'); ?></option> 
                            <option><?php echo lang('status_left'); ?></option> 
                        </select>
                    </div>  
                    
                    <div class="form-group">
                        <label class="control-label"><?php echo lang('image'); ?></label>
                        <div class="">
                            <div class="fileupload fileupload-new" data-provides="fileupload">
                                <div class="fileupload-new thumbnail" style="width: 150px;">
                                    <img src="//www.placehold.it/200x150/EFEFEF/AAAAAA&amp;text=no+image"  name="img1" alt="" />
                                </div>
                                <div class="fileupload-preview fileupload-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 20px;"></div>
                                <div>
                                    <span class="btn btn-white btn-file">
                                        <span class="fileupload-new"><i class="fa fa-paper-clip"></i> Select image</span>
                                        <span class="fileupload-exists"><i class="fa fa-undo"></i> Change</span>
                                        <input type="file" class="default" name="img_url"/>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash();?>" />
                    <div class="form-group col-md-12">
                        <button type="submit" name="submit" class="btn btn-info pull-right row"><?php echo lang('submit'); ?></button>
                    </div>

                </form>

            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<!-- Edit Event Modal-->


<script>
    $(document).ready(function () {
        var table = $('#editable-sample').DataTable({
            responsive: true,

            dom: "<'row'<'col-sm-3'l><'col-sm-5 text-center'B><'col-sm-4'f>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-5'i><'col-sm-7'p>>",
            buttons: [
                'excelHtml5',
                'pdfHtml5',
                {
                    extend: 'print',
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, 6, 7, 8, 9],
                    }
                },
            ],

            aLengthMenu: [
                [25, 50, 100, -1],
                [25, 50, 100, "All"]
            ],
            iDisplayLength: -1,
            "order": [[3, "asc"]],

            "language": {
                "lengthMenu": "_MENU_",
                search: "_INPUT_",
                "url": "common/assets/DataTables/languages/<?php echo $this->language; ?>.json" 
            },
        });
        table.buttons().container()
                .appendTo('.custom_buttons');
    });
</script>

<script>
    $(document).ready(function () {
        $(".flashmessage").delay(3000).fadeOut(100);
    });
</script>

<script type="text/javascript">

    $(".table").on("click", ".inffo", function () {
        //    e.preventDefault(e);
        // Get the record's ID via attribute  
        var iid = $(this).attr('data-id');

        $("#img1").attr("src", "uploads/cardiology-patient-icon-vector-6244713.jpg");
        $('.staffIdClass').html("").end()
        $('.nameClass').html("").end()
        $('.emailClass').html("").end()
        $('.addressClass').html("").end()
        $('.phoneClass').html("").end()
        $('.genderClass').html("").end()
        $('.birthdateClass').html("").end()
        $('.joiningClass').html("").end()
        $('.basicSalaryClass').html("").end()
        $('.departmentClass').html("").end()       
        $('.updateDateClass').html("").end()       

        $.ajax({
            url: 'staff/getStaffByJason?id=' + iid,
            method: 'GET',
            data: '',
            dataType: 'json',
        }).success(function (response) {
            // Populate the form fields with the data returned from server

            $('.staffIdClass').append(response.staff.id).end()
            $('.nameClass').append(response.staff.name).end()
            $('.emailClass').append(response.staff.email).end()
            $('.addressClass').append(response.staff.address).end()
            $('.phoneClass').append(response.staff.phone).end()
            $('.genderClass').append(response.staff.gender).end()
            $('.birthdateClass').append(response.staff.birth_date).end()
            $('.joiningClass').append(response.staff.joining_date).end()
            $('.basicSalaryClass').append("<?php echo $settings->currency;?>"+" "+response.staff.basic_salary).end()
            $('.departmentClass').append(response.department).end()
            $('.updateDateClass').append(response.updated_date).end()

            if (typeof response.staff.img_url !== 'undefined' && response.staff.img_url != '') {
                $("#img1").attr("src", response.staff.img_url);
            }

            $('#infoModal').modal('show');

        });
    });

</script>


<script type="text/javascript">

    $(".table").on("click", ".editbutton", function () {
        //    e.preventDefault(e);
        // Get the record's ID via attribute  
        var iid = $(this).attr('data-id');
        $("#img1").attr("src", "uploads/cardiology-patient-icon-vector-6244713.jpg");
        $('#editStaffForm').trigger("reset");
        $.ajax({
            url: 'staff/getStaffByJason?id=' + iid,
            method: 'GET',
            data: '',
            dataType: 'json',
        }).success(function (response) {
            // Populate the form fields with the data returned from server

            $('#editStaffForm').find('[name="id"]').val(response.staff.id).end()
            $('#editStaffForm').find('[name="name"]').val(response.staff.name).end()
            $('#editStaffForm').find('[name="email"]').val(response.staff.email).end()
            $('#editStaffForm').find('[name="address"]').val(response.staff.address).end()
            $('#editStaffForm').find('[name="phone"]').val(response.staff.phone).end()
            $('#editStaffForm').find('[name="gender"]').val(response.staff.gender).end()
            $('#editStaffForm').find('[name="birth_date"]').val(response.staff.birth_date).end()
            $('#editStaffForm').find('[name="department"]').val(response.staff.department).end() 
            $('#editStaffForm').find('[name="basic_salary"]').val(response.staff.basic_salary).end() 
            $('#editStaffForm').find('[name="joining_date"]').val(response.staff.joining_date).end() 
            $('#editStaffForm').find('[name="status"]').val(response.staff.status).end() 

            if (typeof response.staff.img_url !== 'undefined' && response.staff.img_url != '') {
                $('#editStaffForm').find('[name="img1"]').attr("src", response.staff.img_url);
            }

            $('#myModal2').modal('show');

        });
    });

</script>