
<!--sidebar end-->
<!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <section class="panel">
            <header class="panel-heading">
            <?php echo lang('staff'); ?> <?php echo lang('salary'); ?> <?php echo lang('list'); ?>
                <div class="clearfix no-print col-md-8 pull-right">
                <?php echo validation_errors(); ?>
                    <div class="pull-right"></div>
                    <a data-toggle="modal" href="#myModal">
                        <div class="btn-group pull-right">
                            <button id="" class="btn green btn-xs">
                                <i class="fa fa-plus-circle"></i>  <?php echo lang('add_new'); ?> <?php echo lang('salary'); ?> 
                            </button>
                        </div>
                    </a>
                </div>
            </header>
            <div class="panel-body">
                <div class="adv-table editable-table ">

                    <div class="space15"></div>
                    <table class="table table-striped table-hover table-bordered" id="editable-sample">
                        <thead>
                            <tr>
                                <th><?php echo lang('serial'); ?></th>
                                <th><?php echo lang('staff'); ?></th>
                                <th><?php echo lang('department'); ?></th>
                                <th><?php echo lang('for_month'); ?></th>
                                <th><?php echo lang('work'); ?> <?php echo lang('days'); ?></th>
                                <th><?php echo lang('basic'); ?> <?php echo lang('salary'); ?></th>
                                <th><?php echo lang('allowance'); ?></th>
                                <th><?php echo lang('total'); ?> <?php echo lang('salary'); ?></th>
                                <th><?php echo lang('payment'); ?> <?php echo lang('date'); ?></th>                              
                                <th><?php echo lang('status'); ?></th>
                                <th><?php echo lang('added'); ?> <?php echo lang('date'); ?></th>
                                <th class="no-print"><?php echo lang('options'); ?></th>
                            </tr>
                        </thead>
                        <tbody>

                        <?php foreach ($salarys as $salary) { ?>
                            <tr class="">
                                <td><?php echo $salary->id; ?></td>
                                <td><?php echo $salary->staffName; ?>, <?php echo lang('id'); ?>: <?php echo $salary->staff; ?></td>
                                <td><?php echo $salary->departmentName; ?></td>
                                <td><?php echo $salary->for_month; ?></td> 
                                <td><?php echo $salary->work_day; ?></td>
                                <td><?php echo $settings->currency; ?> <?php echo $salary->basic_salary; ?></td>
                                <td><?php echo $settings->currency; ?> <?php echo $salary->allowance; ?></td> 
                                <td><?php echo $settings->currency; ?> <?php echo $salary->basic_salary+$salary->allowance; ?></td> 
                                <td><?php echo date('d-m-Y', $salary->payment_date); ?></td>                                                                           
                                <td>
                                <?php if ($salary->status == lang('paid')) { ?>
                                    <span class="badge bg-primary"><?php echo $salary->status; ?></span>
                                <?php } elseif ($salary->status == lang('pending')) { ?> 
                                    <span class="badge bg-info"><?php echo $salary->status; ?></span>
                                <?php } else { ?> 
                                    <span class="badge bg-warning"><?php echo $salary->status; ?></span>
                                <?php } ?> 
                                </td>
                                <td><?php echo date('d-m-Y', $salary->added_date); ?></td>
                                <td class="no-print">
                                    <?php echo ' <a type="button" class="btn detailsbutton inffo" title="' . lang('info') . '" data-toggle = "modal" data-id="' . $salary->id . '"><i class="fa fa-info"> </i> ' . lang('details') . '</a>'; ?>
                                    <button type="button" class="btn btn-info btn-xs btn_width editbutton" title="<?php echo lang('edit'); ?>" data-toggle="modal" data-id="<?php echo $salary->id; ?>"><i class="fa fa-edit"></i> <?php echo lang('edit'); ?></button>   
                                    <a class="btn btn-info btn-xs btn_width delete_button" title="<?php echo lang('delete'); ?>" href="staff/deleteSalary?id=<?php echo $salary->id; ?>" onclick="return confirm('Are you sure you want to delete this item?');"><i class="fa fa-trash"></i> <?php echo lang('delete'); ?></a>
                                </td>
                            </tr>
                        <?php } ?>

                        </tbody>
                    </table>
                </div>
            </div>
        </section>
        <!-- page end-->
    </section>
</section>
<!--main content end-->
<!--footer start-->


<!-- Add Salary Modal-->
<div class="modal fade" id="myModal"  role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title"><?php echo lang('add_new'); ?> <?php echo lang('salary'); ?></h4>
            </div>
            <div class="modal-body">
                <form role="form" id="AddSalaryForm" action="staff/addSalary" class="clearfix" method="post" enctype="multipart/form-data">
                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('staff'); ?>*</label>
                        <select class="form-control js-example-basic-single pos_select" name="staff" id="pos_select" required>
                            <option value="">Select</option>
                                <?php foreach ($staffs as $staff) { ?>
                                    <option value="<?php echo $staff->id; ?>">
                                    <?php echo $staff->name.", ".lang('id').": ".$staff->id.", ".$staff->departmentName; ?> 
                                    </option>
                                <?php } ?> 
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('salary'); ?> <?php echo lang('for_month'); ?>*</label>
                        <div class="">
                            <select class="input-special for_month" id="for_month" name="for_month" required> 
							    <option value="">Select</option>  
                            <?php
                                for ($i_month = 1; $i_month <= 12; $i_month++) { 
                                echo '<option value="'.$i_month.'"'.'>'. date('F', mktime(0,0,0,$i_month)).'</option>';
                            }
                            ?>
                            </select>

                            <select class="input-special for_year" id="for_year" name="for_year" required> 
							    <option value="">Select</option>  
                            <?php
                            $year_start  = 2020;
                            $year_end = date('Y') + 1; // next Year
                            $selected_year = date('Y'); //current year
                            for ($i_year = $year_start; $i_year <= $year_end; $i_year++) {
                                $selected = ($selected_year == $i_year ? ' selected' : '');
                                echo '<option value="'.$i_year.'"'.$selected.'>'.$i_year.'</option>';
                            }
                            ?>
                        </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('total'); ?> <?php echo lang('leave'); ?></label>
                        <input type="text" class="form-control" id="leave_days" name="leave_days" readonly>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('basic'); ?> <?php echo lang('salary'); ?></label>
                        <div class="">
                            <input type="text" class="input-special" name="basic_salary" readonly>
                            <input type="text" class="input-special" name="basic_salary_day" readonly>
                            <input type="hidden" name="basic_salary_day_hidden">
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('work'); ?> <?php echo lang('days'); ?>*</label>
                        <input type="number" class="form-control" min=1 id="work_day" name="work_day" required>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('allowance'); ?> (<?php echo $settings->currency; ?>)</label>
                        <input type="number" class="form-control" min=0 id="allowance" name="allowance">
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('total'); ?> <?php echo lang('salary'); ?> (<?php echo $settings->currency; ?>)</label>
                        <input type="number" class="form-control" name="total_salary" readonly>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('remarks'); ?></label>
                        <input type="text" class="form-control" name="remarks">
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('payment'); ?> <?php echo lang('date'); ?></label>
                        <input type="text" class="form-control default-date-picker" name="payment_date" readonly>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('status'); ?>*</label>
                        <select class="form-control" name="status" required>  
                            <option><?php echo lang('paid'); ?></option> 
                            <option><?php echo lang('pending'); ?></option> 
                        </select>
                    </div>                     

                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash();?>" />
                    <div class="form-group col-md-12">
                        <button type="submit" name="submit" class="btn btn-info pull-right row"><?php echo lang('submit'); ?></button>
                    </div>

                </form>

            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<!-- Add Salary Modal-->

<!-- Info Salary Modal-->
<div class="modal fade" id="infoModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-lg"> 
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">  <?php echo lang('salary'); ?>  <?php echo lang('info'); ?> (<?php echo lang('id'); ?>: <span class="salaryIdClass text-primary"></span>)</h4>
            </div>
            <div class="modal-body row" style="margin-top: 15px;">                    
                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1"><?php echo lang('staff'); ?></label>
                        <div class="staffClass"></div>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1"><?php echo lang('for_month'); ?></label>
                        <div class="forMonthClass"></div>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1"><?php echo lang('work'); ?> <?php echo lang('days'); ?></label>
                        <div class="workDayClass"></div>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1"><?php echo lang('basic'); ?> <?php echo lang('salary'); ?></label>
                        <div class="basicSalaryClass"></div>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1"><?php echo lang('allowance'); ?></label>
                        <div class="allowanceClass"></div>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1"><?php echo lang('remarks'); ?></label>
                        <div class="remarksClass"></div>
                    </div>

                    <div class="form-group col-md-6">
                        <label><?php echo lang('status'); ?></label>
                        <div class="statusClass"></div>     
                    </div>

                    <div class="form-group col-md-6">
                        <label><?php echo lang('payment'); ?> <?php echo lang('date'); ?></label>
                        <div class="paymentDateClass"></div>     
                    </div>

                    <div class="form-group col-md-6">
                        <label><?php echo lang('added'); ?> <?php echo lang('date'); ?></label>
                        <div class="addedDateClass"></div>     
                    </div>

                    <div class="form-group col-md-6">
                        <label><?php echo lang('added'); ?> <?php echo lang('by'); ?></label>
                        <div class="addedByClass"></div>     
                    </div>

                    <div class="form-group col-md-6">
                        <label><?php echo lang('updated'); ?> <?php echo lang('date'); ?></label>
                        <div class="updatedDateClass"></div>     
                    </div>

                    <div class="form-group col-md-6">
                        <label><?php echo lang('updated'); ?> <?php echo lang('by'); ?></label>
                        <div class="updatedByClass"></div>     
                    </div>

                    <div class="form-group col-md-6">    
                    </div>
              

            </div><!-- /.modal-content -->
        </div><!-- /.modal-dialog -->
    </div>
</div>
<!-- Info Salary Modal-->

<!-- Edit Event Modal-->
<div class="modal fade" id="myModal2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title"><?php echo lang('edit'); ?> <?php echo lang('salary'); ?></h4>
            </div>
            <div class="modal-body">
                <form role="form" id="editSalaryForm" class="clearfix" action="staff/addSalary" method="post" enctype="multipart/form-data">
                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('serial'); ?></label>
                        <input type="text" class="form-control" name="id" value='' placeholder="" readonly>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('staff'); ?></label>
                        <input type="text" class="form-control" name="staff" readonly required>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('salary'); ?> <?php echo lang('for_month'); ?>*</label>
                        <input type="text" class="form-control" name="for_month" readonly>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('work'); ?> <?php echo lang('days'); ?></label>
                        <input type="number" class="form-control" min=1 id="work_day" name="work_day" readonly>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('basic'); ?> <?php echo lang('salary'); ?> (<?php echo $settings->currency; ?>)</label>
                        <input type="number" class="form-control" min=1 id="basic_salary" name="basic_salary" readonly>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('allowance'); ?> (<?php echo $settings->currency; ?>)</label>
                        <input type="number" class="form-control" min=0 id="allowance" name="allowance" readonly>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('total'); ?> <?php echo lang('salary'); ?> (<?php echo $settings->currency; ?>)</label>
                        <input type="number" class="form-control" name="total_salary" readonly>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('remarks'); ?></label>
                        <input type="text" class="form-control" name="remarks">
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('payment'); ?> <?php echo lang('date'); ?></label>
                        <input type="text" class="form-control default-date-picker" name="payment_date" readonly>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('status'); ?>*</label>
                        <select class="form-control" name="status" required>  
                            <option><?php echo lang('paid'); ?></option> 
                            <option><?php echo lang('pending'); ?></option> 
                        </select>
                    </div>                                
                    
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash();?>" />
                    <div class="form-group col-md-12">
                        <button type="submit" name="submit" class="btn btn-info pull-right row"><?php echo lang('submit'); ?></button>
                    </div>

                </form>

            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<!-- Edit Event Modal-->


<script>
    $(document).ready(function () {
        var table = $('#editable-sample').DataTable({
            responsive: true,

            dom: "<'row'<'col-sm-3'l><'col-sm-5 text-center'B><'col-sm-4'f>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-5'i><'col-sm-7'p>>",
            buttons: [
                'excelHtml5',
                'pdfHtml5',
                {
                    extend: 'print',
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
                    }
                },
            ],

            aLengthMenu: [
                [25, 50, 100],
                [25, 50, 100]
            ],
            iDisplayLength: 25,
            "order": [[0, "desc"]],

            "language": {
                "lengthMenu": "_MENU_",
                search: "_INPUT_",
                "url": "common/assets/DataTables/languages/<?php echo $this->language; ?>.json" 
            },
        });
        table.buttons().container()
                .appendTo('.custom_buttons');
    });
</script>

<script>
    $(document).ready(function () {
        $(".flashmessage").delay(3000).fadeOut(100);
    });
</script>

<script type="text/javascript">

    $(".table").on("click", ".inffo", function () {
        //    e.preventDefault(e);
        // Get the record's ID via attribute  
        var iid = $(this).attr('data-id');
        $('.salaryIdClass').html("").end() 
        $('.staffClass').html("").end()  
        $('.basicSalaryClass').html("").end()  
        $('.allowanceClass').html("").end()  
        $('.workDayClass').html("").end()  
        $('.forMonthClass').html("").end()  
        $('.remarksClass').html("").end()  
        $('.statusClass').html("").end()       
        $('.addedByClass').html("").end()
        $('.addedDateClass').html("").end()
        $('.updatedByClass').html("").end()
        $('.updatedDateClass').html("").end()
        $('.paymentDateClass').html("").end() 

        $.ajax({
            url: 'staff/getSalaryByJason?id=' + iid,
            method: 'GET',
            data: '',
            dataType: 'json',
        }).success(function (response) {
            // Populate the form fields with the data returned from server

            $('.salaryIdClass').append(response.salary.id).end()
            $('.staffClass').append(response.salary.staffName+", <?php echo lang('id');?>: "+response.salary.staff+", "+response.salary.departmentName).end()
            $('.basicSalaryClass').append(response.settings.currency+" "+response.salary.basic_salary).end()
            $('.allowanceClass').append(response.settings.currency+" "+response.salary.allowance).end()
            $('.workDayClass').append(response.salary.work_day).end()
            $('.forMonthClass').append(response.salary.for_month).end()
            $('.remarksClass').append(response.salary.remarks).end()
            $('.statusClass').append(response.salary.status).end()
            $('.addedByClass').append(response.added_by).end()
            $('.addedDateClass').append(response.added_date).end()
            $('.updatedByClass').append(response.updated_by).end()
            $('.updatedDateClass').append(response.updated_date).end()
            $('.paymentDateClass').append(response.payment_date).end()

            $('#infoModal').modal('show');

        });
    });

</script>


<script type="text/javascript">

    $(".table").on("click", ".editbutton", function () {
        //    e.preventDefault(e);
        // Get the record's ID via attribute  
        var iid = $(this).attr('data-id');
        $('#editSalaryForm').trigger("reset");
        $.ajax({
            url: 'staff/getSalaryByJason?id=' + iid,
            method: 'GET',
            data: '',
            dataType: 'json',
        }).success(function (response) {
            // Populate the form fields with the data returned from server

            $('#editSalaryForm').find('[name="id"]').val(response.salary.id).end()
            $('#editSalaryForm').find('[name="staff"]').val(response.salary.staffName+", <?php echo lang('id');?>: "+response.salary.staff+", "+response.salary.departmentName).end()
            $('#editSalaryForm').find('[name="basic_salary"]').val(response.salary.basic_salary).end()
            $('#editSalaryForm').find('[name="allowance"]').val(response.salary.allowance).end()
            $('#editSalaryForm').find('[name="work_day"]').val(response.salary.work_day).end()
            $('#editSalaryForm').find('[name="for_month"]').val(response.salary.for_month).end()
            $('#editSalaryForm').find('[name="total_salary"]').val(parseInt(response.salary.basic_salary)+parseInt(response.salary.allowance)).end()
            $('#editSalaryForm').find('[name="payment_date"]').val(response.payment_date).end() 
            $('#editSalaryForm').find('[name="remarks"]').val(response.salary.remarks).end() 
            $('#editSalaryForm').find('[name="status"]').val(response.salary.status).end() 

            $('#myModal2').modal('show');

        });
    });

</script>

<script>
    $(document).ready(function () {
        $(document.body).on('change', '#pos_select', function () {
            var iid = $("select.pos_select option:selected").val();
            $.ajax({
                url: 'staff/getStaffByJason?id=' + iid,
                method: 'GET',
                data: '',
                dataType: 'json',
            }).success(function (response) {
                $('#AddSalaryForm').find('[name="basic_salary"]').val(response.staff.basic_salary+" "+ "<?php echo $settings->currency;?>/<?php echo lang('month');?>").end()
                $('#AddSalaryForm').find('[name="basic_salary_day"]').val((Math.round((response.staff.basic_salary/30)*100)/100).toFixed(2)+" "+ "<?php echo $settings->currency;?>/<?php echo lang('day');?>").end()
                $('#AddSalaryForm').find('[name="basic_salary_day_hidden"]').val(response.staff.basic_salary/30).end()
                $('#AddSalaryForm').find('[name="allowance"]').val("0").end()
                $('#AddSalaryForm').find('[name="work_day"]').val("").end()
                $('#AddSalaryForm').find('[name="total_salary"]').val("").end()
                $('#AddSalaryForm').find('[name="leave_days"]').val("0"+" <?php echo lang('days'); ?>").end()
            });
        });

        $('#work_day').keyup(function () {
            var allowance= $('#AddSalaryForm').find('[name="allowance"]').val();
            var basic_salary_day= $('#AddSalaryForm').find('[name="basic_salary_day_hidden"]').val();
            var work_day= $('#AddSalaryForm').find('[name="work_day"]').val();
            var total_salary=parseFloat(basic_salary_day)*parseInt(work_day)+parseInt(allowance);
            $('#AddSalaryForm').find('[name="total_salary"]').val(total_salary.toFixed(0)).end()
        });

        $('#allowance').keyup(function () {
            var allowance= $('#AddSalaryForm').find('[name="allowance"]').val();
            var basic_salary_day= $('#AddSalaryForm').find('[name="basic_salary_day_hidden"]').val();
            var work_day= $('#AddSalaryForm').find('[name="work_day"]').val();
            var total_salary=parseFloat(basic_salary_day)*parseInt(work_day)+parseInt(allowance);
            $('#AddSalaryForm').find('[name="total_salary"]').val(total_salary.toFixed(0)).end()
        }); 

        $( "#for_month" ).change(function() {           
            var staff = $("select.pos_select option:selected").val();
            var for_month = $("select.for_month option:selected").val();
            var for_year = $("select.for_year option:selected").val();
            $.ajax({
                url: 'staff/getLeaveByStaffByDates?staff=' + staff + '&for_month='+ for_month + '&for_year=' + for_year,
                method: 'GET',
                data: '',
                dataType: 'json',
            }).success(function (response) {
                $('#AddSalaryForm').find('[name="leave_days"]').val(response.leave+" <?php echo lang('days'); ?>").end()
            });
        });

        $( "#for_year" ).change(function() {
            var staff = $("select.pos_select option:selected").val();
            var for_month = $("select.for_month option:selected").val();
            var for_year = $("select.for_year option:selected").val();
            $.ajax({
                url: 'staff/getLeaveByStaffByDates?staff=' + staff + '&for_month='+ for_month + '&for_year=' + for_year,
                method: 'GET',
                data: '',
                dataType: 'json',
            }).success(function (response) {
                $('#AddSalaryForm').find('[name="leave_days"]').val(response.leave+" <?php echo lang('days'); ?>").end()
            });
        })

    });
      
</script>

<style>
    .input-special {
        border: 1px solid #e2e2e4;
        height: 32px !important;
        font-size: 14px;
    }

    #leave_days {
        background-color: #f5f5f5  !important;
        width: 30%;
    }
</style>